/** An instance is a bank account */
public class BankAccount {
    private int account;        // account number
    private int balance;        // amount in the account
    private Transaction trans;   // the last transaction carried out
    /** Deposit amount in this account */
    public void deposit(int amount) {
        balance= balance + amount;
        trans= new Transaction(amount, "deposit");
    }
    
    /** Withdraw amount from this account */
    public void withdraw(int amount) { 
        balance= balance - amount;
        trans= new Transaction(amount, "withdrawal");
    }
    
    /** = the account number */
    public int getAccount() { return account; }
    
    /** An instance is a bank-account transaction */
    private class Transaction {
        int amount;         // amount of transaction
        String transaction;  // e.g. "deposit", "withdrawal"
        
        /** Constructor: instance for this account, kind t, amount n */
        public Transaction(int n, String t) 
            { transaction= t; amount= n; }
        
        /** representation of this Transaction */
        public String toString()
            { return account + ": " + transaction + " " + amount; }
    }
}